import os

from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params

from sandbox.projects.resource_types import SLAVE_NEWSD_APPHOST_REQUESTER


class BuildSlaveNewsdApphostRequester(YaMakeTask):
    """ Build newsd_statework executable"""

    type = 'BUILD_SLAVE_NEWSD_APPHOST_REQUESTER'
    input_parameters = ya_make_build_params() + get_arcadia_params()

    def get_resources(self):
        resources = {
            'description': 'Build newsd_statework',
            'resource_path': os.path.join(os.path.basename(SLAVE_NEWSD_APPHOST_REQUESTER.arcadia_build_path), 'apphost_requester'),
            'resource_type': SLAVE_NEWSD_APPHOST_REQUESTER,
        }
        return {'project': resources}

    def get_targets(self):
        return [SLAVE_NEWSD_APPHOST_REQUESTER.arcadia_build_path]

    def get_arts(self):
        return [{'path': SLAVE_NEWSD_APPHOST_REQUESTER.arcadia_build_path}]


__Task__ = BuildSlaveNewsdApphostRequester
