#!/usr/bin/env python
# coding: utf-8

"""
Builds Snowden archive for Samogon.
"""

from os.path import join as join_path

from sandbox.sandboxsdk import task
from sandbox.sandboxsdk.paths import copy_path, make_folder
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects import resource_types


class BuildSnowdenArchive(task.SandboxTask):

    type = "BUILD_SNOWDEN_ARCHIVE"

    SNOWDEN_URL = "arcadia:/arc/trunk/arcadia/devtools/snowden"

    def on_execute(self):
        # Export snowden.
        snowden_path = self.abs_path("snowden")
        Arcadia.export(self.SNOWDEN_URL, snowden_path)
        # Make servants.
        make_folder(self.abs_path("linux"))
        run_process(
            ["tar", "czfv", self.abs_path("linux", "all.tgz"), "."],
            log_prefix="tar-viewer",
            work_dir=snowden_path,
        )
        # Copy plugin.
        plugin_path = self.abs_path("plugin")
        make_folder(plugin_path)
        copy_path(join_path(snowden_path, "deploy", "__init__.py"), join_path(plugin_path, "__init__.py"))
        # Make archive.
        archive_path = self.abs_path("snowden.tgz")
        run_process(
            ["tar", "czfv", archive_path, "linux", "plugin"],
            log_prefix="tar-archive",
            work_dir=self.abs_path(),
        )
        self.create_resource(
            description="Snowden Archive",
            resource_path=archive_path,
            resource_type=resource_types.SNOWDEN_ARCHIVE,
        )


__Task__ = BuildSnowdenArchive
