# -*- coding: utf-8 -*-

import os

import sandbox.common.types.client as ctc

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.resource_types import STATBOX_PUSHCLIENT
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.build.parameters as build_params


class BuildStatboxPushClientNew(nanny.ReleaseToNannyTask, YaMakeTask):
    type = 'BUILD_STATBOX_PUSHCLIENT'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.ClearBuild,
        build_params.ThinLTO,
        build_params.TargetPlatformFlags,
        build_params.KeepOn,
    ]
    client_tags = ctc.Tag.GENERIC
    cores = 24

    def get_arts(self):
        return [{'path': os.path.join(STATBOX_PUSHCLIENT.arcadia_build_path, 'bin'), 'dest': ''}]

    def get_targets(self):
        return [STATBOX_PUSHCLIENT.arcadia_build_path]

    def get_resources(self):
        target_platform_flags = self.get_target_platform_flags()
        resource_lin = {
            'description': 'Statbox PushClient for Linux',
            'resource_path': "bin/push-client",
            'resource_type': STATBOX_PUSHCLIENT,
            'arch': 'linux',
        }

        resource_win = {
            'description': 'Statbox PushClient for Windows',
            'resource_path': "bin/push-client.exe",
            'resource_type': STATBOX_PUSHCLIENT,
            'arch': 'win_nt',
        }

        has_win = target_platform_flags.lower().find("win") >= 0
        has_lin = target_platform_flags.lower().find("linux") >= 0

        if (has_win and has_lin):
            return {'push-client-linux': resource_lin, 'push-client-windows': resource_win}
        elif (has_win):
            return {'push-client-windows': resource_win}
        else:
            return {'push-client-linux': resource_lin}


__Task__ = BuildStatboxPushClientNew
