# coding: utf-8

from sandbox.projects.BuildSuggest import BuildSuggestDeb
from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import (BuildForAllTask,
        PlatformsListParameter, VersionParameter)


class SuggestPlatforms(PlatformsListParameter):
    values = [('Precise', 'precise'), ]
    default_value = 'precise'


class BuildSuggestForAll(BuildForAllTask):
    type = 'BUILD_SUGGEST_FOR_ALL'
    input_parameters = BuildSuggestDeb.input_parameters + [SuggestPlatforms]

    subtask_type = BuildSuggestDeb
    subtask_description = 'Building web suggest daemon for {target}'
    resource_type = resource_types.SUGGEST_WEBDAEMON
    resource_description = 'Web suggest daemon v{version} for {target}'
    target_to_host_map = {'precise': 'linux_ubuntu_12.04_precise'}

    def on_execute(self):
        if self.ctx.get('build_subtasks_created'):
            dpkg_versions = [task.ctx.get('dpkg-version')
                    for task in self.list_subtasks(load=True)]
            version = dpkg_versions[0]
            if version is not None and all(v == version for v in dpkg_versions):
                self.ctx['dpkg-version'] = version
            self.ctx[VersionParameter.name] = self.ctx.get('dpkg-version', '0.?')
        BuildForAllTask.on_execute(self)


__Task__ = BuildSuggestForAll
