# coding: utf-8

from sandbox.projects import resource_types
from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class SvnVersion(VersionParameter):
    description = 'Svn Version'
    default_value = '1.7.3'


class UseLocalSvnParameter(SandboxBoolParameter):
    name = 'local_svn'
    description = 'Use local svn to checkout scripts'
    default_value = False


class BuildSvn(sbt.ScriptBuildTask):
    type = 'BUILD_SVN'
    input_parameters = [SvnVersion, UseLocalSvnParameter] + sbt.get_script_build_params()
    environment = []

    # ScriptBuildTask fields
    tool_name = 'svn'
    inplace_archive = True
    resource_type = resource_types.SVN_EXECUTABLE

    def prepare(self):
        sbt.ScriptBuildTask.prepare(self)
        if not self.ctx[UseLocalSvnParameter.name]:
            SvnEnvironment().prepare()


__Task__ = BuildSvn
