# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildSvn import BuildSvn
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildSvnForAll(BuildForAllTask):
    type = 'BUILD_SVN_FOR_ALL'
    input_parameters = list(BuildSvn.input_parameters) + [PlatformsListParameter]
    release_to = 'sandbox-releases@yandex-team.ru'

    # BuildForAllTask fields
    subtask_type = BuildSvn
    subtask_description = 'Building Svn {version} for {target}'
    resource_type = resource_types.SVN_EXECUTABLE
    resource_description = 'Svn {version} for {target}'


__Task__ = BuildSvnForAll
