import os
import shutil

from sandbox import sdk2

from sandbox.projects.common.yappy.base_build_patched_test import BuildPatchedTest
from sandbox.projects.BuildTestEnv.resource_types import TestEnvModelBinary, TestEnvProxyBinary


class BuildPatchedTestEnv(BuildPatchedTest):

    class Context(BuildPatchedTest.Context):
        project_remote = None
        run_tests = False

    @property
    def github_context(self):
        return '[Sandbox] Build and test'

    @property
    def project_conf(self):
        return {
            'github': {
                'report_statuses': self.Parameters.report_github_statuses
            }
        }

    @property
    def arcadia_project_path(self):
        return 'testenv/ngui'

    @property
    def bundle_info(self):
        return {
            'model/model': TestEnvModelBinary,
            'proxy/proxy': TestEnvProxyBinary,
        }

    def install(self):
        pass

    def after_build(self):

        with self.info_section('<prepare> find child task resources'):
            child_task = self.find().first()
            project = sdk2.Resource['ARCADIA_PROJECT'].find(task=child_task).first()
            self.Context.project_remote = str(sdk2.ResourceData(project).path)

        with self.info_section('<bundle> binaries'):
            for path, resource_type in self.bundle_info.items():
                src_path = os.path.join(self.Context.project_remote, path)
                dst_path = str(self.path(path))
                os.makedirs(os.path.split(dst_path)[0])
                shutil.copy(src_path, dst_path)
                sdk2.ResourceData(resource_type(self, description=str(resource_type), path=dst_path)).ready()
