# coding: utf-8

from sandbox import sdk2

from sandbox.projects.common.yappy.base_build_ui import BaseBuildUI
from sandbox.projects.BuildTestEnv.resource_types import TestEnvUIBundle


class BuildTestEnvUI(BaseBuildUI):

    @property
    def github_context(self):
        return '[Sandbox] Build and test'

    @property
    def project_conf(self):
        return {
            'github': {
                'report_statuses': self.Parameters.report_github_statuses
            }
        }

    @property
    def bundle_resource_type(self):
        return TestEnvUIBundle

    @property
    def bundle_description(self):
        return 'TestEnv UI bundle'

    def install(self):
        with self.info_section('<npm setup> npm config 1'), sdk2.helpers.ProcessLog(self, 'npm_config_1') as plog:

            sdk2.helpers.subprocess.check_call(
                (
                    self.node.node_bin, self.node.npm_bin, 'config', 'set', '--verbose',
                    '@fortawesome:registry', 'https://npm.fontawesome.com',
                ),
                cwd=self.Context.sources_path, stdout=plog.stdout, stderr=plog.stderr,
            )

        with self.info_section('<npm setup> npm config 2'), sdk2.helpers.ProcessLog(self, 'npm_config_2') as plog:

            sdk2.helpers.subprocess.check_call(
                (
                    self.node.node_bin, self.node.npm_bin, 'config', 'set', '--verbose',
                    '//npm.fontawesome.com/:_authToken',
                    sdk2.Vault.data('MAESTRO', 'npm_fontawesome_oauth_token'),
                ),
                cwd=self.Context.sources_path, stdout=plog.stdout, stderr=plog.stderr,
            )

        super(BuildTestEnvUI, self).install()
