# coding: utf-8

from sandbox import sdk2

from sandbox.projects.resource_types import search_priemka_releasers
from sandbox.projects.resource_types.releasers import marty

testenv_releasers = marty + search_priemka_releasers


class TestEnvResource(sdk2.Resource):
    """
    Abstract TestEnv resource.
    """
    releasable = True
    any_arch = False
    releasers = testenv_releasers
    auto_backup = True


class TestEnvModelBinary(TestEnvResource):
    """
    TestEnv model binary.
    """
    arcadia_build_path = 'testenv/ngui/src/model/'


class TestEnvProxyBinary(TestEnvResource):
    """
    TestEnv proxy binary.
    """
    arcadia_build_path = 'testenv/ngui/src/proxy/'


class TestEnvUIBundle(TestEnvResource):
    """
    Archived TestEnv UI
    """
