# coding: utf-8

from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.BuildTickenator.resource_types as resource_types

RESOURCES = {
    'tickenator': resource_types.TickenatorBackendBinary}


class BuildTickenatorPy(nanny.ReleaseToNannyTask, YaMakeTask):
    """
    Build Tickenator project.
    """
    type = 'BUILD_TICKENATOR_PY'
    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter,
        build_params.UseArcadiaApiFuse,
        build_params.AllowArcadiaApiFallback,
    ]

    def get_resources(self):
        return {
            k: {'description': 'tickenator {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return ['search/mon/tickenator/src']

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]
