# coding: utf-8

from sandbox import sdk2

from sandbox.projects.resource_types.releasers import marty


class TickenatorResource(sdk2.Resource):
    """
    Abstract Tickenator resource.
    """
    releasable = True
    any_arch = False
    releasers = marty
    auto_backup = True


class TickenatorBackendBinary(TickenatorResource):
    """
    Tickenator backend binary.
    """
    arcadia_build_path = 'search/mon/tickenator/bin/'


class TickenatorUIBundle(TickenatorResource):
    """
    Transpiled, minimized and archived files for Tickenator UI.
    """
