# coding=utf-8

from sandbox.projects import resource_types
from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class TmuxVersion(VersionParameter):
    description = 'Tmux Version'
    default_value = '1.9a'


class UseLocalSvnParameter(SandboxBoolParameter):
    name = 'local_svn'
    description = 'Use local svn to checkout scripts'
    default_value = False


class BuildTmux(sbt.ScriptBuildTask):
    type = 'BUILD_TMUX'

    input_parameters = [
        TmuxVersion, UseLocalSvnParameter
    ] + sbt.get_script_build_params()
    tool_name = 'tmux'
    inplace_archive = True
    resource_type = resource_types.TMUX_EXECUTABLE

    def prepare(self):
        sbt.ScriptBuildTask.prepare(self)
        if not self.ctx[UseLocalSvnParameter.name]:
            SvnEnvironment().prepare()


__Task__ = BuildTmux
