# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask


class BuildTsnet2(CommonBuildTask):
    """
        building tsnet2 and ts_calc2 binaries
    """

    type = 'BUILD_TSNET2'

    client_tags = ctc.Tag.Group.LINUX

    TARGET_RESOURCES = (
        (resource_types.TSNET2_EXECUTABLE, 'quality/tsnet/tsnet2/tsnet2'),
        (resource_types.TS_CALC2_EXECUTABLE, 'quality/tsnet/ts_calc2/ts_calc2'),
        (resource_types.TS_CALC2_CLIENT_EXECUTABLE, 'quality/tsnet/ts_calc2_client/ts_calc2_client'),
        (resource_types.TS_EVLOGDUMP_EXECUTABLE, 'quality/tsnet/tools/evlogdump/ts_evlogdump'),
    )


__Task__ = BuildTsnet2
