# coding: utf-8
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.BuildUchenki.resource_types as resource_types

RESOURCES = {'uchenki_exec': resource_types.UchenkiBinary}


class BuildUchenkiBinary(nanny.ReleaseToNannyTask, YaMakeTask):

    type = 'BUILD_UCHENKI_BINARY'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.ClearBuild,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter,
        build_params.UseArcadiaApiFuse,
        build_params.AllowArcadiaApiFallback,
    ]

    def get_resources(self):
        return {
            k: {'description': 'uchenki {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return ['search/mon/uchenki']

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)
