# coding: utf-8
import logging
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.BuildUchenki.resource_types import UchenkiConfigTgz


class UchenkiConfig(sdk2.Task):
    """ Make archive with configs and templates """

    class Parameters(sdk2.Parameters):
        prod = sdk2.parameters.Bool("Production config")
        prestable = sdk2.parameters.Bool("Prestable config")
        test = sdk2.parameters.Bool("Test config")
        templates = sdk2.parameters.Bool("Template")

    def on_execute(self):
        arcadia_path = "arcadia:/arc/trunk/arcadia/search/mon/uchenki"
        path = "."
        Arcadia.export(arcadia_path, path)
        # Archive file
        command = "tar -cvzf config.tgz"
        if self.Parameters.prod:
            command = command + " config/production.yaml"
        if self.Parameters.prestable:
            command = command + " config/prestable.yaml"
        if self.Parameters.test:
            command = command + " config/testing.yaml"
        if self.Parameters.templates:
            command = command + " template_st template_tg"
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("tar")) as pl:
            sp.Popen(command, shell=True, stdout=pl.stdout,
                     stderr=sp.STDOUT).wait()
        # Create resource
        sdk2.ResourceData(UchenkiConfigTgz(
            self, "Output file", "config.tgz"
        ))
