# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types.releasers import marty


class UchenkiResource(sdk2.Resource):
    """
    Abstract Uchenki resource.
    """

    releasable = True
    any_arch = False
    releasers = marty.append('robot-uchenki')
    auto_backup = True


class UchenkiBinary(UchenkiResource):
    """
    Uchenki backend binary
    """

    arcadia_build_path = 'search/mon/uchenki'


class UchenkiFrontend(UchenkiResource):
    """
    Uchenki frontend tar.gz
    """

    any_arch = True


class UchenkiFrontendProxy(UchenkiResource):
    """
    Uchenki frontend proxy docker image
    Node + nginx
    """

    any_arch = True


class UchenkiConfigTgz(UchenkiResource):
    """
    Tar file with configs and templates files inside
    """
    any_arch = True
    auto_backup = False
    executable = False
