from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class ValgrindVersion(VersionParameter):
    description = 'Valgrind version'
    default_value = '3.9.0'


class BuildValgrind(sbt.ScriptBuildTask):
    type = 'BUILD_VALGRIND'
    input_parameters = [ValgrindVersion] + sbt.get_script_build_params()

    # ScriptBuildTask fields
    tool_name = 'valgrind'
    resource_type = resource_types.VALGRIND


__Task__ = BuildValgrind
