# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildValgrind import BuildValgrind
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class ValgrindPlatforms(PlatformsListParameter):
    values = [('Linux', 'linux')]
    default_value = 'linux'


class BuildValgrindForAll(BuildForAllTask):
    type = 'BUILD_VALGRIND_FOR_ALL'
    input_parameters = list(BuildValgrind.input_parameters) + [ValgrindPlatforms]
    release_to = 'sandbox-releases@yandex-team.ru'

    # BuildForAllTask fields
    subtask_type = BuildValgrind
    subtask_description = 'Building Valgrind {version} for {target}'
    resource_type = resource_types.VALGRIND
    resource_description = 'Valgrind {version} for {target}'


__Task__ = BuildValgrindForAll
