# -*- coding: utf-8 -*-

from sandbox.projects.common.nanny import nanny
import sandbox.common.types.misc as ctm
import enrich_config
import logging
import os
import sandbox.projects.resource_types
import sandbox.sandboxsdk.parameters as sdk_parameters
import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task


class ConfigArcadiaUrl(sdk_parameters.SandboxArcadiaUrlParameter):
    default_value = os.path.join(sdk_svn.Arcadia.trunk_url(), 'web/src_setup/lib/setup/video_popular/data/source/popular.v2.json')
    description = 'Path to arcadia video popular config'
    name = 'config_url'
    required = True


class BuildVideoPopularConfig(nanny.ReleaseToNannyTask, sdk_task.SandboxTask):
    '''Build video popular config'''

    type = 'BUILD_VIDEO_POPULAR_CONFIG'

    dns = ctm.DnsType.DNS64

    input_parameters = [ConfigArcadiaUrl]

    def on_execute(self):
        config_url = self.ctx[ConfigArcadiaUrl.name]
        config_name = os.path.basename(config_url)
        config_dir_path = sdk_svn.Arcadia.get_arcadia_src_dir(os.path.dirname(config_url))
        config_file_path = os.path.join(config_dir_path, config_name)

        logging.info('Reading raw video popular config...')
        config = enrich_config.get_config(config_file_path)

        logging.info('Enriching raw video popular config...')
        enrich_config.enrich_config(config)

        logging.info('Creating video popular config resource...')
        config_resource = self.create_resource(
            description='video popular config {}'.format(config_name),
            resource_path=config_name,
            resource_type=sandbox.projects.resource_types.VIDEO_POPULAR_CONFIG)

        logging.info('Dumping video popular config resource data...')
        enrich_config.dump_config(config, config_resource.path)


__Task__ = BuildVideoPopularConfig
