# coding: utf-8
from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt

import sandbox.common.types.client as ctc


class WineVersion(VersionParameter):
    description = 'Wine Version'
    default_value = '1.7.37'


class BuildWine(sbt.ScriptBuildTask):
    type = 'BUILD_WINE'
    input_parameters = [WineVersion] + sbt.get_script_build_params()

    # ScriptBuildTask fields
    tool_name = 'wine'
    inplace_archive = True
    resource_type = resource_types.WINE_EXECUTABLE
    client_tags = ctc.Tag.Group.LINUX


__Task__ = BuildWine
