# coding: utf-8

"""
    Сборка прокси-колуднщиков (algo@ & Co)
"""
import sandbox.projects.common.build.ArcadiaTask as bbt
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.proxy_wizard.provider import ProxyTypes as pt
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask

from os.path import join as pj

import sandbox.common.types.client as ctc


class BuildWizardProxy(CommonBuildTask, ReleaseToNannyTask):
    type = 'BUILD_WIZARD_PROXY'

    build_fields = pt.construct_build_fields()

    input_parameters = build_params.get_common_build_params() + bbt.gen_input_params(build_fields)

    client_tags = ctc.Tag.Group.LINUX

    wizards_root = 'extsearch/wizards'

    TARGET_PATH_TO_NAME_MAP = {
        pj(wizards_root, 'afisha', 'mktrie', 'mktrie'): 'afisha_mktrie',
    }
    TARGET_RESOURCES = pt.construct_target_resources()

    LOCAL_BIN_DIR = 'binaries'

    def initCtx(self):
        self.ctx['notify_via'] = 'email'

    def on_enqueue(self):
        bbt.on_enqueue_input_params(self.ctx, self.build_fields)
        CommonBuildTask.on_enqueue(self)

    def on_release(self, additional_params):
        ReleaseToNannyTask.on_release(self, additional_params)


__Task__ = BuildWizardProxy
