import os

from sandbox import sdk2

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.constants import RELEASE_BUILD_TYPE
import sandbox.common.types.client as ctx
import sandbox.projects.common.build.parameters as build_params


class YasmBalancerReportModule(sdk2.Resource):
    """python module for yasmagent to parse balancer report module output"""
    releasers = [
        'elantsev',
        'avdemin',
        'sourcerer',
        'yoschi',
        'risboo6909',
    ]
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True


class BuildYasmBalancerReport(YaMakeTask):
    """ Build module for yasmagent of balancer report """

    type = 'BUILD_YASM_BALANCER_REPORT'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch
    ]

    client_tags = ctx.Tag.Group.LINUX
    cores = 24

    def get_build_type(self):
        return RELEASE_BUILD_TYPE

    @property
    def resource_path(self):
        return 'balancer/production/yasm_module/balancer_report_fast_parser.so'

    @property
    def resource_name(self):
        return os.path.basename(self.resource_path)

    def get_resources(self):
        return {
            self.resource_name: {
                'description': 'Build yasmagent balancer report module',
                'resource_type': YasmBalancerReportModule,
                'resource_path': self.resource_name,
            }
        }

    def get_targets(self):
        return [os.path.dirname(self.resource_path)]

    def get_arts(self):
        return [{'path': self.resource_path}]


__Task__ = BuildYasmBalancerReport
