# -*- coding: utf-8 -*-

import os
import platform
import logging

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
import sandbox.projects.common.constants as consts
# noinspection PyProtectedMember
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import DoNotRemoveResourcesParameter


def convert_to_win32(target_resources):
    res = []
    for resource_type, target, target_path in target_resources:
        name, ext = os.path.splitext(target)
        if not ext:
            win_target_name = '{}.exe'.format(name)
            win_target_path = os.path.join(os.path.dirname(target_path), win_target_name)
            targ = (resource_type, win_target_name, win_target_path)
        else:
            targ = (resource_type, target, target_path)
        res.append(targ)
    return res


class BuildYmakeTask(CommonBuildTask):
    type = 'BUILD_YMAKE'

    execution_space = 2500

    # XXX: too much email messages for now
    # real_owners = ['snowball', 'kakabba', 'rnefyodov']

    def initCtx(self):
        CommonBuildTask.initCtx(self)
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.YMAKE_BUILD_SYSTEM

    def _target_enabled(self, target):
        return True

    def get_target_resources(self):
        target_resources = CommonBuildTask.get_target_resources(self)
        target_platform = self.ctx.get('target_platform_alias')
        return convert_to_win32(target_resources) if target_platform == 'win32' else target_resources

    def do_execute(self):
        CommonBuildTask.do_execute(self)

        target_platform = self.ctx.get('target_platform_alias')
        logging.info('target_platform_alias=%s', target_platform)
        target_name = 'ymake.exe' if target_platform == 'win32' else 'ymake'
        ymake_dir = self.abs_path(os.path.join(self.LOCAL_RELEASE_DIR, 'devtools/ymake/bin'))
        run_process(['tar', '-czf', self.abs_path('ymake.tgz'), target_name], shell=True, log_prefix='tar',
                    work_dir=ymake_dir)

        if not target_platform:
            target_platform = platform.platform()

        attrs = {
            'ttl': 'inf' if self.ctx.get(DoNotRemoveResourcesParameter.name) else 30,
            'platform': target_platform,
        }

        self.create_resource(
            description='YMake for {target}'.format(target=target_platform),
            resource_path=self.abs_path('ymake.tgz'),
            resource_type=resource_types.YMAKE,
            attributes=attrs
        )

    TARGET_RESOURCES = (
        (resource_types.YMAKE_BINARY, 'devtools/ymake/bin/ymake'),
    )


__Task__ = BuildYmakeTask
