# -*- coding: utf-8 -*-

import os
import logging

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk.task import SandboxTask

from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.environments import *  # noqa

from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxMavenEnvironment
from sandbox.sandboxsdk.environments import SvnEnvironment

SVN_URL = 'arcadia:/robots/trunk/genconf/resources/mobilesearch-report'
SVN_TAGS_URL = 'arcadia:/robots/tags/mobreport'


class BuildZookeeper(SandboxTask):

    environment = (
        SvnEnvironment(),
        SandboxJavaJdkEnvironment('1.8.0'),
        SandboxMavenEnvironment('3.2.2'),
    )

    zookeeper_version = "3.5.9"

    resources = [
        ('ZOOKEEPER_POM_XML',   'pom.xml'),
        ('ZOOKEEPER_BINARY',    'target/zookeeper-{}-jar-with-dependencies.jar'.format(zookeeper_version)),
    ]

    type = 'BUILD_ZOOKEEPER'
    client_tags = ctc.Tag.LINUX_PRECISE & ctc.Tag.IPV4

#    input_parameters = None

    execution_space = 500

    release_to = ['librarian', 'schizophrenia', 'noiseless', 'alximik']

    def arcadia_info(self):
        """
        Gets info for release
        """
        return self.ctx.get('revision'), self.ctx.get('tag'), self.ctx.get('branch')

    def on_execute(self):
        make_folder('svn', delete_content=True)

        rev = Arcadia.get_revision(SVN_URL)
        self.ctx['revision'] = rev
        self.ctx['tag'] = "zookeeper-{}-{}".format(self.zookeeper_version, rev)
        self.ctx['branch'] = "trunk"
        svn_url = '{}@{}'.format(SVN_URL, rev)
        tag_url = '{}/zookeeper-{}-{}'.format(SVN_TAGS_URL, self.zookeeper_version, rev)

        if Arcadia.check(tag_url):
            logging.info("Remove tag {}".format(tag_url))
            Arcadia.delete(tag_url, message='[Sandbox] Remove tag', user='zomb-sandbox-rw')

        logging.info("Create tag {}".format(tag_url))
        Arcadia.create_tag(svn_url, tag_url, 'zomb-sandbox-rw', message='[Sandbox] New tag')

        logging.info("Checkout {}".format(tag_url))
        Arcadia.checkout(tag_url, self.abs_path('svn'))

        logging.info("PATH = {}".format(os.environ['PATH']))

        run_process(['mvn assembly:single'], 'mvn', shell=True, timeout=10800, check=True, work_dir='svn')

        for resource, filename in self.resources:
            logging.info("Creating resouce ({}: {})".format(resource, filename))
            self.create_resource(description=resource,
                                        resource_path=os.path.join('svn', filename),
                                        resource_type=resource,
                                        arch='any')


__Task__ = BuildZookeeper
