import logging

from sandbox import sdk2


class BunkerSetSchedulerCustomField(sdk2.Task):

    class Parameters(sdk2.task.Parameters):
        scheduler_id = sdk2.parameters.Integer("Scheduler ID", required=True)
        name = sdk2.parameters.String("Custom field name", required=True)
        with sdk2.parameters.RadioGroup("Value type") as mode:
            mode.values["string"] = mode.Value("String", default=True)
            mode.values["integer"] = mode.Value("Integer")
            mode.values["dict"] = mode.Value("Mapping")

        with mode.value["string"]:
            stringvalue = sdk2.parameters.String("Value", required=True)

        with mode.value["integer"]:
            integervalue = sdk2.parameters.Integer("Value", required=True)

        with mode.value["dict"]:
            dictvalue = sdk2.parameters.Dict("Value", required=True)

    def on_execute(self):
        logging.info('Starting!')
        scheduler = self.server.scheduler[self.Parameters.scheduler_id]
        fields = scheduler.custom.fields
        if self.Parameters.mode == 'string':
            fields.update([
                {
                    "name": self.Parameters.name,
                    "value": self.Parameters.stringvalue
                }
            ])
        if self.Parameters.mode == 'integer':
            fields.update([
                {
                    "name": self.Parameters.name,
                    "value": self.Parameters.integervalue
                }
            ])
        if self.Parameters.mode == 'dict':
            fields.update([
                {
                    "name": self.Parameters.name,
                    "value": self.Parameters.dictvalue
                }
            ])
        else:
            raise Exception("Unsupported value type!")

        logging.info('Done!')
