grep_bar_navig_log = '''
PRAGMA file('zen_hosts', 'https://proxy.sandbox.yandex-team.ru/{hosts_resource}');
PRAGMA file('host_to_path', 'https://proxy.sandbox.yandex-team.ru/{hosts_to_path_resource}');
PRAGMA file('host_to_country', 'https://proxy.sandbox.yandex-team.ru/{host_to_country_resource}');

$remove_cgi = Python::r_cgi(
    '(String?)->String?',
@@
import urlparse
import urllib

def r_cgi(url):
    parsed = urlparse.urlparse(url)
    cgi = urlparse.parse_qs(parsed.query)
    parsed = parsed._replace(query='')
    for key in cgi.keys():
        if 'utm' in key:
            del cgi[key]
    if parsed.netloc == 'zen.yandex.ru' and 'rid' in cgi:
        del cgi['rid']
    return urlparse.urlunparse(
        parsed._replace(
            query=urllib.urlencode({{k: v[0] for k, v in cgi.iteritems()}})
        )
    )
@@
);

$script = @@
def filter_closure(path):
    with open(path, 'r') as f:
        host_to_path={{s[0]: s[1:] for s in map(lambda line: line.strip().split('\t'), f)}}

        def path_filter(host, path):
            if not host or not path:
                return False
            if host not in host_to_path:
                return False
            return any((path.startswith(prefix) for prefix in host_to_path[host]))

        return path_filter
@@;

$udf = Python::filter_closure(
    "(String)->(String?, String?)->Bool",
    $script
);

$script_2 = @@
def country_closure(path):
    with open(path, 'r') as f:
        host_to_country={{s[0]: '\t'.join(s[1:]) for s in map(lambda line: line.strip().split('\t'), f)}}

        def get_country(host):
            return host_to_country[host]

        return get_country
@@;

$udf_2 = Python::country_closure(
    "(String)->(String?)->String",
    $script_2
);

$callable = $udf(FilePath("host_to_path"));

$callable_2 = $udf_2(FilePath("host_to_country"));

$urls_from_spylog = (
    SELECT $remove_cgi(Url::Decode(Url::GetCGIParam(http_params, 'url'))) AS url
    FROM [{input_table}]
    WHERE
        yasoft IN ('android.yabrowser', 'apad.yabrowser')
        AND String::ToLower(Url::GetHost(Url::Decode(Url::GetCGIParam(http_params, 'url')))) IN ParseFile('String', 'zen_hosts')
        AND $callable(
            String::ToLower(Url::GetHost(Url::Decode(Url::GetCGIParam(http_params, 'url')))),
            String::ToLower(Url::GetPath(Url::Decode(Url::GetCGIParam(http_params, 'url'))))
        )
);

INSERT INTO @urls_from_spylog
WITH TRUNCATE
SELECT *
FROM $urls_from_spylog;

COMMIT;

INSERT INTO [{temp_table}]
WITH TRUNCATE
SELECT url, $callable_2(String::ToLower(Url::GetHost(url))) as countries
FROM @urls_from_spylog;

INSERT INTO [{temp_table_unique}]
WITH TRUNCATE
SELECT key, '' as value
FROM (
    SELECT DISTINCT url as key
    FROM @urls_from_spylog
);
'''

calc_clicks = '''
PRAGMA yt.InferSchema;

$normalized_urls_from_spylog = (
    SELECT r.value as url, l.countries as countries
    FROM [{temp_table}] as l
    JOIN [{temp_table_canonized}] as r
    ON l.url == r.key
);

INSERT INTO [{output_table}]
WITH TRUNCATE
SELECT url, count(*) AS clicks, Some(countries) as countries
FROM $normalized_urls_from_spylog
GROUP BY url
ORDER BY url;
'''
