import logging
from sandbox import sdk2
import os

from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr
from sandbox.common import errors


class CalcZenEmbeddingsPrepareEmbeddingsExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ['zhshishkin']


class CalcZenEmbeddingsPrepareEmbeddings(sdk2.Task):
    '''Prepare embeddings for urls in table'''

    class Parameters(sdk2.Task.Parameters):

        resource_id = sdk2.parameters.LastReleasedResource(
            'Resource Id',
            resource_type=CalcZenEmbeddingsPrepareEmbeddingsExecutable,
            state=(ctr.State.READY,),
            required=True,

        )

        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            yt_vault_token = sdk2.parameters.String('Your token name in vault', default='yt-token', required=True)

            with sdk2.parameters.RadioGroup('Yt host') as yt_host:
                yt_host.values['hahn'] = yt_host.Value(value='Hahn', default=True)
                yt_host.values['banach'] = yt_host.Value(value='Banach')
                yt_host.values['arnold'] = yt_host.Value(value='Arnold')

            input_table = sdk2.parameters.String(
                'Input table of bar-navig-log',
                required=True,
            )

            output_table = sdk2.parameters.String(
                'Result output table',
                required=True,
            )

            jupiter_folder = sdk2.parameters.String(
                'Jupiter folder',
                required=True,
                default='//home/jupiter/backup/walrus'
            )

            shards_folder = sdk2.parameters.String(
                'Stable temp folder (it must not exist)',
                required=True,
            )

            countries_with_modes = sdk2.parameters.String(
                'Zen countries, space separated',
                required=True,
                default='russia',
            )

            models_folder = sdk2.parameters.String(
                'Models folder',
                required=True,
                default='//home/geosearch/zhshishkin/iznanka/w2v_models',
            )

            revive_from = sdk2.parameters.Integer('First snapshot to revive', required=True, default=0)

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        with self.memoize_stage.run_phase:

            runner = self.Parameters.resource_id

            if runner is None:
                raise errors.TaskError('No executable founded')
            runner = sdk2.ResourceData(runner)

            logging.info('Start run')
            with sdk2.helpers.ProcessLog(self, logger='run binary') as pl:
                env = os.environ.copy()
                env['YT_TOKEN'] = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token)
                env['YT_LOG_LEVEL'] = 'DEBUG'
                run = [
                    str(runner.path),
                    '-i', self.Parameters.input_table,
                    '-o', self.Parameters.output_table,
                    '-j', self.Parameters.jupiter_folder,
                    '--model-folder', self.Parameters.models_folder,
                    '--countries', '{}'.format(self.Parameters.countries_with_modes),
                    '-t', self.Parameters.shards_folder,
                    '-p', self.Parameters.yt_host,
                    '--restore', str(self.Parameters.revive_from),
                ]
                ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
                if ret:
                    raise errors.TaskError('run is failed')
