import logging
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.misc as ctm
# import sandbox.projects.sandbox


class CheckDockerLxc(sdk2.Task):
    class Requirements(sdk2.Requirements):
        privileged = True
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Parameters):
        container = sdk2.parameters.Container(
            "LXC container with Docker installed",
            required=True,
            default_value=325077505,
            # type=sandbox.projects.sandbox.LXC_CONTAINER  # FIXME: invalid argument (SANDBOX-6404)
        )

    def on_execute(self):
        logging.info("Execution started")
        self.suspend()
        with sdk2.helpers.ProcessLog(self, logger="docker") as pl:
            sp.check_call(["service", "docker", "start"], stdout=pl.stdout, stderr=sp.STDOUT)
        with sdk2.helpers.ProcessLog(self, logger="docker") as pl:
            sp.check_call(["docker", "version"], stdout=pl.stdout, stderr=sp.STDOUT)
        logging.info("Execution finished")
