from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.network import is_port_free

from sandbox.projects.common import utils


class Ports(parameters.SandboxStringParameter):
    name = 'ports'
    description = "Ports"
    default_value = "3306, 3900-4150, 8100"


class CheckPorts(SandboxTask):

    type = 'CHECK_PORTS'
    description = 'Check that local ports are free on sandbox hosts'

    execution_space = 16  # We work with task contexts and create one very small resource

    input_parameters = [Ports]

    def on_execute(self):
        ports_str = utils.get_or_default(self.ctx, Ports)
        ports = []
        for item in ports_str.split(','):
            item = item.strip()
            try:
                port = int(item)
            except ValueError:
                first, _, last = item.partition('-')
                first = int(first)
                last = int(last)
                ports += range(first, last + 1)
            else:
                ports.append(port)
        busy = [p for p in ports if not is_port_free(p)]
        if busy:
            raise SandboxTaskFailureError("Ports %s are not free" % ', '.join(busy))


__Task__ = CheckPorts
