# coding: utf-8

# $Header$

import os
import codecs
import json
import time

from xml.dom import minidom

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny

svn_path = 'arcadia.yandex.ru:/robots/trunk/clickdaemon-keys'
svn_user = 'zomb-sandbox-rw'
release_comment = 'New key generated, SEPE-7350'


class ClickdaemonKeygen(nanny.ReleaseToNannyTask, SandboxTask):
    type = 'CLICKDAEMON_KEYGEN'

    description = 'Clickdaemon key generator, SEPE-7350'
    execution_space = 32

    def on_execute(self):
        work_dir = Arcadia.checkout(svn_path, 'work_dir')
        run_process(['mv', 'keys.xml', 'keys-old.xml'], work_dir=work_dir, wait=True)
        run_process([os.path.join(work_dir, 'keygen.pl'), '-i', 'keys-old.xml', '-o', 'keys.xml', '-d', '73000'],
            work_dir=work_dir,
            wait=True
        )
        Arcadia.update(work_dir)
        Arcadia.commit(work_dir, release_comment, svn_user)

        xml_filepath = os.path.join(work_dir, 'keys.xml')
        json_filepath = './keys.json'
        self.keys2json(xml_filepath, json_filepath)

        self.create_resource(
            'Clickdaemon keys %s' % time.strftime('%c'),
            json_filepath,
            resource_types.CLICKDAEMON_KEYS
        )

    def on_success(self):
        # don't forget to mark resources as ready
        SandboxTask.on_success(self)

        self.create_subtask(
            task_type='RELEASE_ANY',
            input_parameters={
                'check_already_released': False,
                'release_task_id': self.id,
                'release_status': 'stable',
                'release_subject': release_comment,
                'release_comments': release_comment
            },
            description="Clickdaemon keys (task id: %s) autorelease" % str(self.id)
        )

    def keys2json(self, xml_filepath, json_filepath):
        parsed = minidom.parse(xml_filepath)
        key_nodes = parsed.documentElement.getElementsByTagName('key')
        res = []
        for node in key_nodes:
            res.append({
                'id': node.getAttribute('id'),
                'sig': node.getAttribute('sig'),
                'timestamp': node.getAttribute('timestamp'),
                'val': node.firstChild.nodeValue
            })
        with codecs.open(json_filepath, 'w', 'utf-8') as json_file:
            json_file.write(json.dumps(res, indent=2))


__Task__ = ClickdaemonKeygen
