# -*- coding: utf-8 -*-
import logging
import os

from sandbox import sdk2

from sandbox.common.types.task import Status
from sandbox.sandboxsdk import paths


class CollectResources(sdk2.Task):
    """
    Сollect releasable resources from tasks list
    """
    class Parameters(sdk2.Parameters):
        tasks = sdk2.parameters.List('Tasks with releasable resources', sdk2.parameters.Integer)

    class Context(sdk2.Task.Context):
        created_res_root = 'resources'
        created_resources = []
        collected_resources = []
        copied_attributes = []

    def on_execute(self):
        sdk2.WaitTask(self.Parameters.tasks, Status.Group.FINISH, wait_all=True)
        for task_id in self.Parameters.tasks:
            logging.debug('Process task: %s', task_id)
            task_resources = sdk2.Resource.find(task_id=task_id).limit(1000)
            for resource in task_resources:
                logging.debug('Process resource: %s', str(resource))
                if getattr(resource, 'releasable', False):
                    logging.debug('Collect resource: %s', str(resource.type))
                    res = sdk2.Resource[resource.id]
                    if str(res.type) not in self.Context.collected_resources:
                        resource_data = sdk2.ResourceData(res)
                        output_resource_path = os.path.join(self.Context.created_res_root, str(res.type))

                        if str(res.type) not in self.Context.created_resources:
                            created_res = res.type(self, res.description, output_resource_path)
                            for attr in self.Context.copied_attributes:
                                if hasattr(res, attr):
                                    setattr(created_res, attr, getattr(res, attr))

                        paths.copy_path(str(resource_data.path), output_resource_path)
                        self.Context.collected_resources.append(str(res.type))
