import os
import sys
import StringIO
import subprocess

from sandbox.projects.common.BaseCompareYaMakeOutputsTask import BaseCompareYaMakeOutputsTask


class CompareDiffTestExampleOutputs(BaseCompareYaMakeOutputsTask):

    def compare(self, build_output1, build_output2, testing_out_stuff_dir):
        import sandboxsdk.svn
        sys.path.append(sandboxsdk.svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/contrib/deprecated/python/diff2html"))
        import diff2html

        test_out_rel_path = os.path.join(testing_out_stuff_dir, "out.txt")

        p = subprocess.Popen(
            [
                "diff", "--unified=50",
                os.path.join(build_output1, test_out_rel_path),
                os.path.join(build_output2, test_out_rel_path)
            ],
            stdout=subprocess.PIPE, stderr=subprocess.PIPE,
        )
        out, err = p.communicate()

        if p.returncode == 1:
            input = StringIO.StringIO(out)
            htmlOutput = StringIO.StringIO()
            diff2html.parse_input(input, htmlOutput, "diff.txt", None, None, None)

            return htmlOutput.getvalue()

        if p.returncode != 0:
            return err
