from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import task

from sandbox.projects import resource_types
from sandbox.projects.common import profiling as search_profiling


class Profile1Parameter(parameters.ResourceSelector):
    name = 'profile1_resource_id'
    description = 'First profile resource'
    resource_type = resource_types.PROFILE_RESULTS
    required = True


class Profile2Parameter(parameters.ResourceSelector):
    name = 'profile2_resource_id'
    description = 'Second profile resource'
    resource_type = resource_types.PROFILE_RESULTS
    required = True


class CompareFlameGraphs(task.SandboxTask, search_profiling.ProfilingTask):
    """
        Generates differential FlameGraph
    """

    type = 'COMPARE_FLAME_GRAPHS'
    input_parameters = (
        Profile1Parameter,
        Profile2Parameter,
    )

    def on_execute(self):
        profile1_path = self.sync_resource(self.ctx[Profile1Parameter.name])
        profile2_path = self.sync_resource(self.ctx[Profile2Parameter.name])
        self._profiling_diff(profile1_path, profile2_path, "perf.diff")
        self.ctx["compare_result"] = True  # This is for compatibility with CompareBasesearchPerformance in TestEnv


__Task__ = CompareFlameGraphs
