# -*- coding: utf-8 -*-

import pprint

import sandbox.common.types.client as ctc

from sandbox.projects.common.fusion.compare_task import CompareFusionResultsTask

from sandbox.projects.common.fusion.params import RunMode, ExternalFactorNamesResource
from sandbox.sandboxsdk import parameters
from sandbox.projects import resource_types


class ProdResponsesParameter(parameters.LastReleasedResource):
    name = 'prod_responses_id'
    description = 'Prod fusion responses'
    resource_type = resource_types.BASESEARCH_HR_RESPONSES


class NewResponses(parameters.LastReleasedResource):
    name = 'new_responses_id'
    description = 'New fusion responses'
    resource_type = resource_types.BASESEARCH_HR_RESPONSES


class CompareFusionResponses(CompareFusionResultsTask):
    """
    The task gets production configs for fusion
    """
    type = 'COMPARE_FUSION_RESPONSES'
    client_tags = ctc.Tag.Group.LINUX
    input_parameters = (ProdResponsesParameter, NewResponses, RunMode, ExternalFactorNamesResource)

    def get_short_task_result(self):
        return "%s factors diff" % len(self.ctx.get("diffs", []))

    def on_enqueue(self):
        CompareFusionResultsTask.on_enqueue(self)
        resource = self._create_resource(
            self.descr, 'compare_result',
            resource_types.FUSION_RESPONSES_COMPARE_RESULT
        )
        self.ctx['out_resource_id'] = resource.id

    def dump_diff(self):
        with open('compare_result', 'w') as f:
            for param in ["diffs", "zeroes", "mango_diffs", "mango_zeroes", "fresh_diffs", "fresh_zeroes"]:
                f.write(param + "\n")
                f.write(pprint.pformat(self.ctx.get(param, "NOT DEFINED IN THE TASK")))

    def on_execute(self):
        self.get_short_stats(self.ctx[RunMode.name])
        self.dump_diff()
        self.verify_results()


__Task__ = CompareFusionResponses
