# -*- coding: utf-8 -*-

import os

from sandbox.projects import resource_types
from sandbox.sandboxsdk import parameters as sp
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import paths


class DolbilkaOutput1(sp.LastReleasedResource):
    name = 'dolbilka_output1_resource_id'
    description = 'output 1'
    resource_type = resource_types.IDX_QUERY_OUTPUT
    group = 'Task resources'


class DolbilkaOutput2(sp.LastReleasedResource):
    name = 'dolbilka_output2_resource_id'
    description = 'output 2'
    resource_type = resource_types.IDX_QUERY_OUTPUT
    group = 'Task resources'


class CompareIdxQueryOutputs(SandboxTask):
    """
        Сравнивает два выхлопа ``idx_query``.
    """
    type = 'COMPARE_IDX_QUERY_OUTPUTS'

    input_parameters = [
        DolbilkaOutput1,
        DolbilkaOutput2,
    ]

    def on_enqueue(self):
        SandboxTask.on_enqueue(self)
        resource = self._create_resource(self.descr, 'pantera_factors.diff', resource_types.DBG_DOLBILKA_COMPARE_RESULT)
        self.ctx['out_resource_id'] = resource.id

    def on_execute(self):
        output1 = self.sync_resource(self.ctx[DolbilkaOutput1.name])
        output2 = self.sync_resource(self.ctx[DolbilkaOutput2.name])

        diff_resource = channel.sandbox.get_resource(self.ctx['out_resource_id'])
        diff_handle = open(diff_resource.path, 'w')
        diff_err_handle = open(os.path.join(paths.get_logs_folder(), 'diff.err'), 'w')
        diff_proc = process.run_process(
            [
                'diff',
                output1,
                output2,
            ],
            stdout=diff_handle,
            stderr=diff_err_handle,
            outputs_to_one_file=False,
            check=False,
        )
        diff_handle.close()
        diff_err_handle.close()

        self.ctx['changed_factors'] = diff_proc.returncode != 0

    def get_short_task_result(self):
        if not self.is_completed():
            return None
        return "diff" if self.ctx['changed_factors'] else "no diff"


__Task__ = CompareIdxQueryOutputs
