# -*- coding: utf-8 -*-

import logging
import os

from sandbox.common import itertools as sb_it
from sandbox.projects.common.base_search_quality.tree import htmldiff


def html_diff(path_to_diffs, data, nodes_per_file):
    """
        :param data: list<tuple(name_node, node1, node2)>
        (node1, node2 instances of base_search_quality.tree.node.Node, name_mode -- string)
    """
    logging.info("Split {} compared items to {} per file".format(len(data), nodes_per_file))

    length = len(str(len(data)))
    changed_props = htmldiff.ChangedProps()
    cnt = 0
    for data_part in sb_it.chunker(data, nodes_per_file):
        n = len(data_part)

        name_of_part = str(cnt).zfill(length) + "-" + str(cnt + n - 1).zfill(length)
        full_path_html = os.path.join(path_to_diffs, "diff_{}.html".format(name_of_part))
        logging.info("Starting to compare {}".format(name_of_part))

        with open(full_path_html, 'w') as f_html:
            def write_body():
                for i in range(n):
                    rec_id = cnt + i
                    name_node, node1, node2 = data_part[i]
                    name_node = "request {}: reqid={}:".format(rec_id, name_node)
                    node_types = {}
                    f_html.write(htmldiff.StartBlock(name_node))
                    htmldiff.write_tree_diff(f_html, rec_id, node1, node2, node_types, changed_props)
                    f_html.write(htmldiff.EndBlock())

            htmldiff.WriteDiff(f_html, write_body)

        logging.info("Finish comparing {}".format(name_of_part))
        cnt += n

    logging.info("Start write compact diff")
    full_path_compact = os.path.join(path_to_diffs, "compact_diff.html")
    with open(full_path_compact, 'w') as f:
        changed_props.write(f)

    diff_nodes = {}
    for set_pairs in changed_props.itervalues():
        for pair in set_pairs:
            diff_nodes[pair[0]] = None

    class DiffResult:
        def __init__(self, diff_count, compare_count):
            self.diff_count = diff_count
            self.compare_count = compare_count

    return DiffResult(len(diff_nodes), len(data))
