# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters

from sandbox.projects.websearch.basesearch.CompareBasesearchResponses import CompareBasesearchResponses

import re


def apply_patcher(obj, path, patcher):
    def impl(o, index):
        name = path[index]
        subitems = o._nodes.get(name, [])
        if index < len(path) - 1:
            for item in subitems:
                impl(item, index + 1)
        else:
            patcher(subitems)
    impl(obj, 0)


def make_attrs_patcher(attrs):
    aindex = ['"' + i + '"' for i in attrs]

    def do_patch(items):
        i = 0
        while i < len(items):
            if items[i]._props['Key'][0] in aindex:
                del items[i]
            else:
                i = i + 1

    path = 'Grouping/Group/Document/ArchiveInfo/GtaRelatedAttribute'.split('/')

    def result(response):
        apply_patcher(response, path, do_patch)

    return result


http_url_re = re.compile('^"http://')


def make_url_patcher():
    def do_patch(items):
        assert(len(items) == 1)
        url = items[0]._props['Url'][0]
        items[0]._props['Url'] = [http_url_re.sub('"', url)]

    path = 'Grouping/Group/Document/ArchiveInfo'.split('/')

    def result(response):
        apply_patcher(response, path, do_patch)

    return result


class Params(object):
    class IgnoreAttrs(parameters.SandboxStringParameter):
        name = 'ignore_attrs'
        description = 'Attrs to ignore (space-separated list)'

    class RemoveHttp(parameters.SandboxBoolParameter):
        name = 'remove_http'
        description = 'Remove http:// from urls'

    params = (IgnoreAttrs, RemoveHttp)


class CompareNewsBasesearchResponses(CompareBasesearchResponses):
    """
        Сравнивает два выхлопа (базового) поиска, полученных в human-readable (hr=da) формате.
        Строит diff по запросам и по изменившимся свойствам.
        Использует результаты задачи GET_BASESEARCH_RESPONSES.
        Умеет выкидывать ненужные атрибуты
    """

    type = 'COMPARE_NEWS_BASESEARCH_RESPONSES'

    input_parameters = CompareBasesearchResponses.input_parameters + Params.params

    def _get_response_patchers(self):
        patchers = CompareBasesearchResponses._get_response_patchers(self)

        ign_params = self.ctx.get(Params.IgnoreAttrs.name)
        if ign_params:
            patchers.append(make_attrs_patcher(frozenset(ign_params.split(' '))))

        if self.ctx.get(Params.RemoveHttp.name):
            patchers.append(make_url_patcher())

        return patchers


__Task__ = CompareNewsBasesearchResponses
