# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters as sp

from sandbox.projects import resource_types
from sandbox.projects.common.news.compare import CompareApphostResponses


class QueriesResourceParameter(sp.LastReleasedResource):
    name = 'queries_resource_id'
    description = 'Queries (optional)'
    resource_type = resource_types.SLAVE_NEWSD_APPHOST_REQUESTS


class NewsdResponses1Parameter(sp.LastReleasedResource):
    name = 'newsd_responses1_resource_id'
    description = 'Newsd responses #1'
    resource_type = resource_types.SLAVE_NEWSD_APPHOST_RESPONSES


class NewsdResponses2Parameter(sp.LastReleasedResource):
    name = 'newsd_responses2_resource_id'
    description = 'Newsd responses #2'
    resource_type = resource_types.SLAVE_NEWSD_APPHOST_RESPONSES


class SaveHtmlDiffParameter(sp.SandboxBoolParameter):
    name = 'save_html_diff'
    description = 'Save html diff'
    default_value = False


class CompareNewsdApphostResponses(CompareApphostResponses):
    """
        Сравнивает результаты обстрела slave_newsd запросами из AppHost'а
        Использует результаты задачи GET_NEWSD_APPHOST_RESPONSES
    """
    type = 'COMPARE_NEWSD_APPHOST_RESPONSES'

    input_parameters = (
        QueriesResourceParameter,
        NewsdResponses1Parameter,
        NewsdResponses2Parameter,
        SaveHtmlDiffParameter,
    )

    def init_resource(self):
        resource = self.create_resource(
            self.descr, 'compare_result',
            resource_types.SLAVE_NEWSD_RESPONSES_COMPARE_RESULT,
            attributes={'backup_task': True},
        )
        return resource.id

    def get_first_responses(self):
        return self.ctx[NewsdResponses1Parameter.name]

    def get_second_responses(self):
        return self.ctx[NewsdResponses2Parameter.name]

    def get_queries(self):
        return self.ctx[QueriesResourceParameter.name]

    def save_html(self):
        return self.ctx[SaveHtmlDiffParameter.name]


__Task__ = CompareNewsdApphostResponses
