# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.task import SandboxTask

from sandbox.projects import resource_types
from sandbox.projects.common.base_search_quality import threadPool as tp
from sandbox.projects.common.base_search_quality import response_diff_task as RDT
from sandbox.projects.common.base_search_quality import basesearch_response_parser as BRP
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import utils

import sandbox.projects.common.proxy_wizard as PW
import sandbox.projects.common.proxy_wizard.Responses as PWR


class CompareProxyWizardResponses(PWR.QueriesBasedTask):
    type = 'COMPARE_PROXY_WIZARD_RESPONSES'
    input_parameters = PWR.QueriesBasedTask.input_parameters + [
        PW.Responses1ResultParameter,
        PW.Responses2ResultParameter,
        tp.UseMultiprocessing,
        RDT.QueriesPerFileParameter,
        RDT.MaxDiffSizeParameter,
        RDT.MaxDiffFilesParameter,
    ]

    def on_enqueue(self):
        SandboxTask.on_enqueue(self)
        channel.task = self
        out_resource = self.create_resource(
            self.descr, 'compare_result',
            resource_types.PROXY_WIZARD_RESPONSES_COMPARE_RESULT
        )
        self.ctx['out_resource_id'] = out_resource.id

    def _get_diff_path(self):
        return channel.sandbox.get_resource(self.ctx['out_resource_id']).path

    def _load_responses(self, responses_resource_id):
        self.sync_resource(responses_resource_id)
        responses_resource = channel.sandbox.get_resource(responses_resource_id)

        with utils.TimeCounter('parsing responses'):
            responses = BRP.parse_responses(responses_resource.path)

        return responses_resource, responses

    def on_execute(self):
        make_folder(self._get_diff_path())
        resp1 = self.ctx[PW.Responses1ResultParameter.name]
        resp2 = self.ctx[PW.Responses2ResultParameter.name]
        (responses1_resource, responses1) = self._load_responses(resp1)
        (responses2_resource, responses2) = self._load_responses(resp2)

        if utils.check_resources_by_md5(responses1_resource, responses2_resource, self._get_diff_path()):
            self.ctx['compare_result'] = True
            return

        (queries) = self.load_queries()
        self.ctx['num_of_queries'] = len(queries)

        self.write_diff_result(queries, responses1, responses2)

        if not self.ctx['compare_result']:
            eh.check_failed('diff found')


__Task__ = CompareProxyWizardResponses
