# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters as sp

from sandbox.projects import resource_types
from sandbox.projects.common.news.compare import CompareApphostResponses


class QueriesResourceParameter(sp.LastReleasedResource):
    name = 'queries_resource_id'
    description = 'Queries (optional)'
    resource_type = resource_types.ROUTERD_REQUESTS


class RouterdResponses1Parameter(sp.LastReleasedResource):
    name = 'routerd_responses1_resource_id'
    description = 'Routerd responses #1'
    resource_type = resource_types.ROUTERD_RESPONSES


class RouterdResponses2Parameter(sp.LastReleasedResource):
    name = 'routerd_responses2_resource_id'
    description = 'Routerd responses #2'
    resource_type = resource_types.ROUTERD_RESPONSES


class SaveHtmlDiffParameter(sp.SandboxBoolParameter):
    name = 'save_html_diff'
    description = 'Save html diff'
    default_value = False


def filter_debug(answer):
    if answer.get("answers"):
        for a in answer["answers"]:
            a.pop("reqid", None)

            # NEWS-12025
            if a.get("type", None) == "tz_info":
                for tz_selector in ("default", "lr", "real", "tuned"):
                    a.get(tz_selector, {}).clear()

    return answer


class CompareRouterdResponses(CompareApphostResponses):
    """
        Сравнивает результаты обстрела routerd запросами из AppHost'а
        Использует результаты задачи GET_ROUTERD_RESPONSES
    """
    type = 'COMPARE_ROUTERD_RESPONSES'

    input_parameters = (
        QueriesResourceParameter,
        RouterdResponses1Parameter,
        RouterdResponses2Parameter,
        SaveHtmlDiffParameter,
    )

    def init_resource(self):
        resource = self.create_resource(
            self.descr, 'compare_result',
            resource_types.ROUTERD_RESPONSES_COMPARE_RESULT,
            attributes={'backup_task': True},
        )
        return resource.id

    def get_first_responses(self):
        return self.ctx[RouterdResponses1Parameter.name]

    def get_second_responses(self):
        return self.ctx[RouterdResponses2Parameter.name]

    def get_queries(self):
        return self.ctx[QueriesResourceParameter.name]

    def save_html(self):
        return self.ctx[SaveHtmlDiffParameter.name]

    def get_filter_debug_func(self):
        return filter_debug


__Task__ = CompareRouterdResponses
