import logging

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.common.YMakeBase import YMakeBase, YMakeCache


def need_create_children(task):
    return not task.Context.dry_run_task_id or not task.Context.fresh_run_task_id


def create_child_ymake_task(task, description, arcadia_url, ymake_bin, use_cache, use_json_cache, cache_resource=None):
    child_task = YMakeBase(
        task,
        description=description
    )

    child_task.Parameters.arcadia_url = arcadia_url
    child_task.Parameters.use_arcadia_api = task.Parameters.use_arcadia_api
    child_task.Parameters.ymake_bin = ymake_bin
    child_task.Parameters.cache_resource = cache_resource
    child_task.Parameters.use_cache = use_cache
    child_task.Parameters.use_json_cache = use_json_cache
    child_task.Parameters.use_patch_mode = use_cache and task.Parameters.use_patch_mode
    child_task.Parameters.use_arc_changelist = child_task.Parameters.use_patch_mode and task.Parameters.use_arc_changelist
    child_task.Parameters.fail_if_patch_unavailable = child_task.Parameters.use_patch_mode and task.Parameters.fail_if_patch_unavailable
    child_task.Parameters.gen_conf_opts = task.Parameters.gen_conf_opts
    ymake_opts = ['-k', '--xs', '--xg', '--xu', '--xy', '-J', 'graph.json']
    if task.Parameters.compare_darts:
        ymake_opts += ['-A', 'test.dart', '-H', 'java.dart', '-o', 'makefiles.dart']
    if task.Parameters.use_fs_cache_only:
        ymake_opts.append('--xF')
    child_task.Parameters.ymake_opts = ymake_opts
    child_task.Parameters.targets = task.Parameters.targets
    child_task.Parameters.hash_salt = task.Parameters.hash_salt
    child_task.Parameters.dump_metrics = True

    child_task.save()
    return child_task


def create_all(task):
    default_ymake = None

    need_default_ymake = task.Parameters.default_ymake_type == 'last_ymake' \
                         and (not task.Parameters.ymake_bin_new or not task.Parameters.ymake_bin_old)
    if need_default_ymake:
        default_ymake = sdk2.Resource.find(type=resource_types.YMAKE_BINARY, state='READY').first()
        logging.info('Use ymake binary #{} as default'.format(default_ymake.id))

    fresh_run = create_child_ymake_task(task, 'Child task of #{} (1st run)'.format(task.id),
                                        task.Parameters.arcadia_url_old,
                                        task.Parameters.ymake_bin_old or default_ymake,
                                        False,
                                        False)

    need_cache = task.Parameters.use_cache or task.Parameters.use_json_cache
    cache = task.Parameters.cache_resource
    if not cache and need_cache:
        cache_hash = fresh_run.calculate_hash()  # hash(fresh_run) = hash(dry_run)
        logging.info('Try to find cache with hash="{}"'.format(cache_hash))
        cache = next(iter(sdk2.Resource.find(type=YMakeCache, state='READY', attrs={'parameters_hash': cache_hash, 'cache_based': False}).limit(1)), None)
        if cache:
            logging.info('Use ymake cache #{}'.format(cache.id))
            task.Context.discovered_cache_id = cache.id
        else:
            logging.warning('Unable to find suitable cache, run ymake without cache')

    dry_run = create_child_ymake_task(task, 'Child task of #{} (2nd run)'.format(task.id),
                                      task.Parameters.arcadia_url_new,
                                      task.Parameters.ymake_bin_new or default_ymake,
                                      task.Parameters.use_cache,
                                      task.Parameters.use_json_cache,
                                      cache)

    fresh_run.enqueue()
    task.Context.fresh_run_task_id = fresh_run.id
    dry_run.enqueue()
    task.Context.dry_run_task_id = dry_run.id
    return [fresh_run, dry_run]
