# coding: utf-8

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask


class GeneratorParameter(SandboxStringParameter):
    name = 'generator'
    description = 'generator host'
    default_value = 'brasero01'


class VersionParameter(SandboxStringParameter):
    name = 'version'
    description = 'version'


class CopyDataRuntime(SandboxTask):
    """
        Забираем data.runtime с генератора и сохраняем как ресурс
    """

    type = 'COPY_DATA_RUNTIME'

    input_parameters = (GeneratorParameter, VersionParameter)

    def on_execute(self):
        version = self.ctx['version']
        link = 'rsync://{}/hol/arkanavt-{}/data.runtime'.format(self.ctx['generator'], version)
        self.remote_copy(link,
                         self.abs_path(),
                         protocol='rsync',
                         exclude=['.source', '.tmp', '*.000'],
                        )
        self.create_resource('data.runtime %s' % version,
                             'data.runtime',
                             'DATA_RUNTIME_CACHE',
                             attributes={'upper.version': version}
                            )


__Task__ = CopyDataRuntime
