from sandbox.projects import resource_types

from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import channel

from sandbox.projects.common import apihelpers

import csv


class CountUnknownTasks(task.SandboxTask):
    type = 'COUNT_UNKWNOWN_TASKS'

    input_parameters = []

    execution_space = 3522

    CTX_REDEFINES = {'kill_timeout': 3600, 'do_not_restart': True}

    def initCtx(self):
        self.ctx.update(self.CTX_REDEFINES)

    def on_execute(self):
        old_counter = dict()
        old_resourse = apihelpers.get_last_resource(resource_types.TASK_COUNTER_RESOURCE)
        if old_resourse is not None:
            path = self.sync_resource(old_resourse)
            with open(path, 'r') as resource_file:
                csv_file = csv.reader(resource_file)
                next(csv_file)  # skiping header
                for row in csv_file:
                    old_counter[row[0]] = int(row[1])

        new_counter = dict()
        tasks = channel.channel.sandbox.list_task_types()
        for t in tasks:
            tasks = channel.channel.sandbox.list_tasks(task_type=t, status='UNKNOWN')
            new_counter[t] = new_counter.get(t, 0) + len(tasks)

        new_resource = self.create_resource(self.descr, 'unknowntasks.csv', 'TASK_COUNTER_RESOURCE')
        with open(new_resource.path, 'w') as resource_file:
            csv_file = csv.writer(resource_file)
            csv_file.writerow(['type', 'count', 'delta'])
            for i, k in enumerate(sorted(new_counter, key=new_counter.get, reverse=True)):
                delta = new_counter[k] - old_counter.get(k, 0)
                if new_counter[k] > 0:
                    csv_file.writerow([k, new_counter[k], delta])
                if i < 10:
                    self.ctx['%d. %s' % (i, k)] = [new_counter[k], delta]


__Task__ = CountUnknownTasks
