import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.sandboxsdk import svn, task, process
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import SandboxSvnUrlParameter
from sandbox.projects.common.gencfg.utils import get_venv_id


class RequirementsUrl(SandboxSvnUrlParameter):
    name = 'requirements_url'
    description = 'Url of requirements.txt'
    default_value = svn.Arcadia.trunk_url() + '/infra/clusterstate/requirements.txt'


class SrcUrl(SandboxSvnUrlParameter):
    name = 'src_url'
    description = 'Url of source dir'
    default_value = svn.Arcadia.trunk_url() + '/infra/clusterstate'


class Task(task.SandboxTask):
    """ Task builds bundle with venv and py program """

    type = "CREATE_CLUSTERSTATE_VENV"
    client_tags = ctc.Tag.Group.LINUX
    input_parameters = [RequirementsUrl, SrcUrl]

    def on_execute(self):
        reqs = self.ctx.get(RequirementsUrl.name)
        venvid = get_venv_id(reqs, self)
        self.sync_resource(venvid)
        venvres = channel.sandbox.get_resource(venvid)
        process.run_process(['tar', 'xvzf', venvres.path], log_prefix='untar', shell=True)
        src_dir = export_src_dir(self.ctx.get(SrcUrl.name))

        process.run_process(['tar', 'czf', 'bundle.tar.gz', 'virtualenv', src_dir], log_prefix='tar', shell=True)

        resource = self.create_resource(
            description='bundle with venv and src',
            resource_path='bundle.tar.gz',
            resource_type=str(resource_types.CLICKHOUSE_GRAPHS_BUNDLE),
            arch='linux'
        )

        self.ctx['RESOURCES'] = {'resources': [resource.id]}


def export_src_dir(src_url):
    dir_name = src_url.split('/')[-1]
    svn.Arcadia.export(src_url, dir_name)
    return dir_name


__Task__ = Task
