# -*- coding: utf-8 -*-
import os
import shutil
import logging

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError

from sandbox.projects.common.search.components import get_fusion_search
from sandbox.projects.common.fusion.task import FusionTestTask

from sandbox.projects import resource_types


class CreateFusionDb(FusionTestTask):
    """
    Feeds a bunch of ducuments to fusion and saves the index after it is reported as  ready by fusion conroller.
    """

    type = 'CREATE_FUSION_DB'

    def on_enqueue(self):
        resource = self._create_resource(
            self.descr,
            "fusion_db",
            resource_types.SEARCH_DATABASE,
        )
        self.ctx['out_resource_id'] = resource.id

    def on_execute(self):
        fusion = get_fusion_search(get_db=False, max_documents=self.get_max_docs())
        try:
            self.init_fusion_with_dump(fusion)
        finally:
            fusion.stop()
        self.save_index(fusion.index_dir)

    def save_index(self, index_dir):
        index = os.path.join(index_dir, "index_0000000000_0000000000")
        if os.path.exists(index):
            result_path = self.abs_path("fusion_db")
            if os.path.exists(result_path):
                logging.error("Directory %s already exists. Removing")
                shutil.rmtree(result_path)
            shutil.copytree(index, result_path)
        else:
            raise SandboxTaskFailureError("Index dir is missing {}. Failed to save it as a resource.".format(index))

        channel.sandbox.set_resource_attribute(self.ctx['out_resource_id'], "fusion", "true")


__Task__ = CreateFusionDb
