# -*- coding: utf-8 -*-

import logging
import os
import time

from sandbox.projects.common.build.parameters import ArcadiaUrl

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import ssh
from sandbox.sandboxsdk import task
from sandbox.sandboxsdk.svn import Arcadia


class TestMode(parameters.SandboxBoolParameter):
    name = 'test_mode'
    description = 'Testing mode'


def get_create_ukrop_branch_params():
    return [
        ArcadiaUrl,
        TestMode,
    ]


class CreateUkropBranch(task.SandboxTask):

    type = 'CREATE_UKROP_BRANCH'

    input_parameters = get_create_ukrop_branch_params()

    branch_name_tpl = 'ukrop/ukrop-stable-{date}'

    create_msg_tpl = 'New Ukrop branch (sandbox task id: {task_id}).'
    create_user = 'search-ukrop-rw'
    create_ssh_key = 'search-ukrop-rw-ssh-private'

    install_msg_tpl = 'Install {name} for {branch} (no merge).'
    install_sub_paths = [
            ('arcadia/yweb/robot/ukrop/re/local.ymake', 'arcadia/local.ymake'),
    ]

    notify_to = 'robot-ukrop'

    def initCtx(self):
        email = self.notify_to
        if self.ctx[TestMode.name]:
            email = 'rdna'
        self.ctx['notify_via'] = 'email'
        self.ctx['notify_if_finished'] = email

    def on_execute(self):
        src_root = Arcadia.parent_dir(self.ctx[ArcadiaUrl.name])

        branch_name = self.branch_name_tpl.format(date=time.strftime('%F'))
        dst_root = Arcadia.parent_dir(Arcadia.branch_url(branch_name))

        create_msg = self.create_msg_tpl.format(task_id=self.id)

        logging.info('Create {dst} from {src}.'.format(src=src_root,
                                                       dst=dst_root))
        with ssh.Key(self, self.owner, self.create_ssh_key):
            Arcadia.copy(src=src_root,
                         dst=dst_root,
                         message=create_msg,
                         user=self.create_user)
            branch_root = dst_root
            for src_sub_path, dst_sub_path in self.install_sub_paths:
                src_path = Arcadia.append(branch_root, src_sub_path)
                dst_path = Arcadia.append(branch_root, dst_sub_path)
                install_msg = self.install_msg_tpl.format(
                                name=os.path.basename(dst_path),
                                branch=os.path.basename(branch_name))
                logging.info('Install {src} to {dst}.'.format(src=src_path,
                                                              dst=dst_path))
                Arcadia.copy(src=src_path,
                             dst=dst_path,
                             message=install_msg,
                             user=self.create_user)


__Task__ = CreateUkropBranch
