from sandbox.projects import resource_types
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk import svn, task, process
from sandbox.sandboxsdk.parameters import SandboxSvnUrlParameter
from sandbox.projects.common.gencfg.utils import REQS, Reqs


class RequirementsUrl(SandboxSvnUrlParameter):
    name = 'requirements_url'
    description = 'Url of requirements.txt'
    default_value = svn.Arcadia.trunk_url() + '/infra/clusterstate/requirements.txt'


class Task(task.SandboxTask):
    """ Task creates venv for Clusterstate """

    type = "CREATE_VENV"

    input_parameters = [RequirementsUrl]
    client_tags = ctc.Tag.Group.LINUX

    def on_execute(self):
        build_virtualenv(self.ctx.get(RequirementsUrl.name))

        process.run_process(['tar', 'czf', 'bundle.tar.gz', 'virtualenv'], log_prefix='tar', shell=True)

        resource = self.create_resource(
            description='bundle with virtual environment',
            resource_path='bundle.tar.gz',
            resource_type=str(resource_types.OTHER_RESOURCE),
            arch='linux'
        )

        self.ctx['RESOURCES'] = {'resources': [resource.id]}
        self.ctx[REQS] = Reqs.read_reqs('requirements.txt')


def build_virtualenv(requirements_url):
    process.run_process(['/skynet/python/bin/virtualenv', '--system-site-packages', 'virtualenv'], log_prefix='virtualenv', shell=True)
    svn.Arcadia.export(requirements_url, 'requirements.txt')

    link = 'https://pypi.yandex-team.ru/simple/'

    args = ['install', '-I', '-r', 'requirements.txt', '--index-url', link]
    process.run_process(['virtualenv/bin/pip'] + args)

    process.run_process(['/skynet/python/bin/virtualenv', '--relocatable', 'virtualenv'], log_prefix='virtualenv', shell=True)


__Task__ = Task
