# coding=utf-8

import json
import logging
import time


def convert_to_time_tuple(t):
    return (t.tm_hour, t.tm_min, t.tm_sec)


def can_deploy_resource(resource, local_time):
    try:
        attrs = 'attributes'
        if isinstance(resource, dict) and attrs in resource and 'deploy_start' in resource[attrs] and 'deploy_finish' in resource[attrs]:
            now = convert_to_time_tuple(local_time)
            attr_time_format = '%H:%M:%S'
            deploy_start = convert_to_time_tuple(time.strptime(resource[attrs]['deploy_start'], attr_time_format))
            deploy_finish = convert_to_time_tuple(time.strptime(resource[attrs]['deploy_finish'], attr_time_format))

            if deploy_start <= deploy_finish:
                if deploy_start <= now and now <= deploy_finish:
                    return True
            else:
                if deploy_start <= now or now <= deploy_finish:
                    return True

            logging.info('Skip deploy resource: %s because of deploy time attributes, now: %s', json.dumps(resource), str(now))
            return False
    except Exception as e:
        logging.error('Error processing resource attributes: %s', str(e))

    return True


def filter_by_deploy_attrs(resources, local_time):
    filtered_resources = {}
    for name, resource in resources.iteritems():
        if can_deploy_resource(resource, local_time):
            filtered_resources[name] = resource.copy()

    return filtered_resources
