# -*- coding: utf-8 -*-

import logging
import time

import os

from sandbox.projects import DeployNannyDashboard
from sandbox.projects.MediaLib.media_zk import zk_client
from sandbox.projects.MediaLib.shardmap import SvnShardmapDir
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.task import SandboxTask

SHARDMAP_RESOURCE_TYPE = 'VIDEO_BASE_ACC_SHARDMAP'
SHARDMAP_SVN_DIR = 'arcadia:/robots/trunk/genconf/shardmaps/VIDEO/ACCEPTANCE/'
DASHBOARD_NAME = 'video_newdb'
RELEASE_TYPE = 'stable'
SHARDMAP_DEPLOY_RECIPE = 'deploy_video_newdb'
ZK_NEWDB_FLAG = '/media-services/video/flags/newdb_video_sbase/on_production'


class DeployVideoBaseNewdbShardmap(SandboxTask):
    execution_space = 128
    type = 'DEPLOY_VIDEO_BASE_NEWDB_SHARDMAP'
    input_parameters = []

    def initCtx(self):
        # timeout - 2 days
        self.ctx['kill_timeout'] = 2 * 24 * 60 * 60

    def on_execute(self):
        if not self.list_subtasks():
            svn_shardmaps = SvnShardmapDir(arcadia_url=SHARDMAP_SVN_DIR)
            latest_shardmap = svn_shardmaps.get_latest_shardmap()
            logging.debug("Found latest shardmap: {}".format(latest_shardmap.shardmap_filename))

            resources = channel.sandbox.list_resources(resource_type=SHARDMAP_RESOURCE_TYPE,
                                                       attribute_name='shardmap_filename',
                                                       attribute_value=latest_shardmap.shardmap_filename,
                                                       status='READY')

            if resources:
                logging.debug("Shardmap {} has already been published".format(latest_shardmap.shardmap_filename))
                return

            self.ctx['shardmap_filename'] = latest_shardmap.shardmap_filename
            self.set_info("Deploy {}".format(latest_shardmap.shardmap_filename))

            create_shardmap_task_params = {
                'remote_file_protocol': 'svn',
                'remote_file_name': os.path.join(SHARDMAP_SVN_DIR, latest_shardmap.shardmap_filename),
                'created_resource_name': latest_shardmap.shardmap_filename,
                'resource_type': SHARDMAP_RESOURCE_TYPE,
                'resource_attrs': "shardmap_filename={}".format(latest_shardmap.shardmap_filename)
            }

            create_shardmap_subtask = self.create_subtask(task_type='CREATE_SHARDMAP_RESOURCE',
                                                          description=latest_shardmap.shardmap_filename,
                                                          input_parameters=create_shardmap_task_params)

            deploy_task_params = {
                'deployment_task_id': create_shardmap_subtask.id,
                'deployment_release_status': RELEASE_TYPE,
                'deployment_nanny_dashboard_name': DASHBOARD_NAME,
                'deployment_nanny_dashboard_recipe': SHARDMAP_DEPLOY_RECIPE,
                'deployment_nanny_bool_wait': True
            }
            self.create_subtask(
                task_type=DeployNannyDashboard.DeployNannyDashboard.type,
                description='Deploy video base acc shardmap',
                input_parameters=deploy_task_params
            )
            self.wait_all_tasks_completed(self.list_subtasks())
        else:
            self.set_info("Upload complete")
            with zk_client() as zk:
                zk.set(ZK_NEWDB_FLAG, value='{} newdb_video_sbase-{}'.format(self.ctx['shardmap_filename'], int(time.time())))


__Task__ = DeployVideoBaseNewdbShardmap
