# -*- coding: utf-8 -*-

import logging
from sandbox.projects.ReleaseMediaShardmaps import ReleaseMediaShardmaps

SHARDMAP_RESOURCE_TYPE = 'VIDEO_MMETA_SHARDMAP'
SHARDMAP_SVN_DIR = 'arcadia:/robots/trunk/genconf/shardmaps/VIDMMETA/'
SHARDMAP_REGEXP = 'shardmap-(?P<shardmap_ts>\d+)-(?P<shardmap_date>\d+)-(?P<shardmap_time>\d+).map'
DASHBOARD_NAME = 'video_mmeta'
RELEASE_TYPE = 'stable'
SHARDMAP_DEPLOY_RECIPE = 'deploy_mmetas'
DEPLOY_SERVICE_GROUP = 'mmeta_prod, mmeta_hamster'
DEPLOY_TASK = 'DEPLOY_NANNY_DASHBOARD'


class DeployVideoMmetaShardmap(ReleaseMediaShardmaps):
    execution_space = 128
    type = 'DEPLOY_VIDEO_MMETA_SHARDMAP'
    input_parameters = []

    def local_init(self):
        self.ctx['shardmap_resource_type'] = SHARDMAP_RESOURCE_TYPE
        self.ctx['svn_shardmap_dir'] = SHARDMAP_SVN_DIR
        self.ctx['shardmap_regexp'] = SHARDMAP_REGEXP
        self.ctx['release_latest'] = True

    def postaction(self):
        logging.debug("Start executing postaction")
        resources = self.list_resources(resource_type=SHARDMAP_RESOURCE_TYPE)
        logging.debug("Got resources: {}".format(resources))
        if not resources:
            logging.debug("Got no resources!")
            return

        deploy_task_params = {
            'deployment_task_id': self.id,
            'deployment_release_status': RELEASE_TYPE,
            'deployment_nanny_dashboard_name': DASHBOARD_NAME,
            'deployment_nanny_dashboard_recipe': SHARDMAP_DEPLOY_RECIPE,
            'deployment_nanny_dashboard_filter': DEPLOY_SERVICE_GROUP
        }
        self.create_subtask(
            task_type=DEPLOY_TASK,
            description='Deploy mmeta shardmap',
            input_parameters=deploy_task_params
        )
        logging.debug("End executing postaction")


__Task__ = DeployVideoMmetaShardmap
